unit SGridEdit01;
(*
   ========================================================================
       .
   ========================================================================
     :
      1.    StringGrid Editor
           " "
      2.  (  )  
           StringGrid
   ========================================================================
    
   ()  ,    , , .
   ========================================================================
       
   ()   , ,  
   ========================================================================
*)
interface

uses //  
     SysUtils, Classes, Controls, Dialogs, StdCtrls, Grids, Graphics;

// ------------------------------------------------------------------------
// 23.02.2013
//      
type TSGEdCB = record
  fMv   : boolean;  //       
  EdM   : boolean;  // StringGrid     
  fRE   : boolean;  //      
  //------------
  //      
  SRow  : integer;  // Row -   
  SCol  : integer;  // Col -   
  SInt  : integer;  //    
  SScl  : integer;  // ,   
  //-------------
  //       
  NInt  : integer;  //     
  NScl  : integer;  //  ,   
  //-------------
  NTxt  : string;   //     StringGrid
  //-------------
  //       
  NRow  : integer;  // Row -  Click - 
  NCol  : integer;  // Col -  Click - 
  //-------------
  //       
  ECode : integer;
end;


// ------------------------------------------------------------------------
//    StringGrid Editor
//   " "
procedure InitSGridEd(SGridEd : TStringGrid; GridLen : integer);


//   TStringGrid  Integer 
function SGCellToInt(Sender: TObject;       //    TStringGrid
                     ACol, ARow:  Integer;  //  
                     CellTxt : string;      //   
                 var CellInt : integer;     //   
                 var ECode   : integer      //   
                     ) : boolean;

// ========================================================================
implementation

// ========================================================================
//     StringGrid    Integer 
// ========================================================================
// 01.02.2013
//   StringGrid Editor
procedure InitSGridEd(SGridEd : TStringGrid; GridLen : integer);
const CellSize = 24;   //    
begin
   with SGridEd do
   begin
      //     StringGrid
      RowCount  := GridLen;
      ColCount  := SGridEd.RowCount;
      //  
      FixedRows := 0;
      FixedCols := 0;
      //     
      DefaultRowHeight := CellSize;
      DefaultColWidth  := CellSize;
      //    StringGrid
      Width  := (CellSize + 2) * GridLen + 2;
      Height := SGridEd.Width;
      //       
      Options := [goVertLine,goHorzLine,goEditing];
      //  ScrolBars
      ScrollBars := ssNone;
      //  
      Color := clWindow;
      //   StringGrid    
      Row := GridLen div 2;
      Col := GridLen div 2;
   end;
end;
// ------------------------------------------------------------------------
// 26.10.2008
//       
function CellTextToInt (Text : string; var Digit : integer): boolean;
begin
  Result := False;
  if Trim(Text) <> ''
  then begin
    try
      Digit := StrToInt(Trim(Text));
      Result := True;
    except
      Digit := 0;
    end;
  end
  else begin
    Digit  := 0;
    Result := True;
  end;
end; // of function

// ========================================================================
//     Integer 
// ========================================================================
// 21.02.2013
//   TStringGrid  Integer 
function SGCellToInt(Sender: TObject;       //    TStringGrid
                     ACol, ARow:  Integer;  //  
                     CellTxt : string;      //   
                 var CellInt : integer;     //   
                 var ECode   : integer      //   
                     ) : boolean;
var WD : integer;
begin
    Result := False;                        //  
    ECode  := -1;                           //  
    //---------------------------------
    //    Grid
    if Sender is TStringGrid
    then begin
       with TStringGrid(Sender) do
       begin
         //---------------------------------
         //     
         if Trim(CellTxt) <> '-'
         then begin
           //   
           if Trim(CellTxt) <> ''
           then begin
              //     
              if CellTextToInt (Trim(CellTxt), WD)
              then begin
                 //     
                 ECode    := 0;
                 CellInt := WD;
                 Result  := True;
              end
              else begin
                 MessageDlg('    : ' + CellTxt
                          + #13#10
                          + '    .',
                          mtWarning, [mbOk], 0);
              end;
           end
           else begin
                //     
                ECode   := 1;
                CellInt := 0;
                Result  := True;
           end;  {of if Value <> '' }
         end
         else begin
            //     
            ECode   := 2;
            CellInt := 0;
            Result  := True;
         end;
       end; // of with TStringGrid(Sender)
    end;  // of if Sender is TStringGrid
end; // of procedure

// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================
end.
